/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.CECBit;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CECByte {
    protected int bitSize;
    protected int data;
    protected boolean eom;
    protected boolean ack;
    protected boolean bad;

    public CECByte(int n, boolean bl, boolean bl2) {
        this.data = n;
        this.eom = bl;
        this.ack = bl2;
        this.bad = false;
    }

    public CECByte(Vector<CECBit> vector, int n) {
        this.bitSize = vector.size();
        int n2 = 0;
        if (this.bitSize - n < 10) {
            this.bad = true;
            this.data = -1;
            this.eom = false;
            this.ack = false;
            return;
        }
        for (int i = n; i < n + 8; ++i) {
            CECBit cECBit = vector.get(i);
            if (cECBit.isData()) {
                n2 <<= 1;
                n2 |= cECBit.value() ? 1 : 0;
            }
            if (!cECBit.isInvalid()) continue;
            this.bad = true;
        }
        this.data = n2;
        this.eom = vector.get(n + 8).value();
        this.ack = vector.get(n + 9).value();
    }

    public String toString() {
        if (this.data == -1) {
            return "I!";
        }
        return String.format("%02X", this.data);
    }

    public String toAscii() {
        if (this.data >= 32 && this.data <= 127) {
            return String.format("%c", this.data);
        }
        return ".";
    }

    public int getData() {
        return this.data;
    }

    public boolean getEOM() {
        return this.eom;
    }

    public boolean getACK() {
        return this.ack;
    }

    public boolean isError() {
        return this.bad;
    }
}

